%This Model has been adapted from the MATLAB code presented in Hoppensteadt
%and Peskin "Modling and Simulation in Medicine and the Life Sciences

%Constants for p(x)
p1=4;                       %units: pN     
GAMMA=0.322;                %units: /nm

%Constants for u
alpha=14;                   %probability per unit time for attachment: /s
beta=126;                   %probability per unit time for detachment: /s
n0=10000;                   %number of crossbridges
A=5;                        %displacement of newly attached crossbridge: nm
dt=0.01/(alpha+beta);       %duration of time step: s
klokmax = 4000;

%number of bins for population density function:
nbins=round(sqrt(n0*alpha/(alpha+beta)));

%Model parameters
Tstart=14/(alpha+beta);    %time at which motion begins: s
V=500;                     %shortening velocity for t>Tstart: nm/s

%All crossbridges are initially detached.
a=zeros(1,n0);
x0=zeros(1,n0);

  
  